---
Difficulty: Hard  
Source: Daily-Question (POTD 30-Nov)  
Tags:
- Graph
- Eulerian Path
- Depth-First Search
---

# 🚀 *2097 - Valid Arrangement of Pairs* 🧠

### Problem Link:  
[**LeetCode - Valid Arrangement of Pairs**](https://leetcode.com/problems/valid-arrangement-of-pairs/description/?envType=daily-question&envId=2024-11-30)



## 💡 **Problem Breakdown:**

You are given a `0-indexed` 2D integer array `pairs` where `pairs[i] = [startᵢ, endᵢ]`.  
An arrangement of pairs is valid if:  
For every index `i` $(where \(1 \leq i < pairs.length\))$, we have:
$\[ endᵢ₋₁ = startᵢ \]$

Return **any valid arrangement of pairs**. It is guaranteed that the input will always allow a valid arrangement.  



## 🔍 **Example Walkthrough:**

#### Example 1:
**Input:**  
`pairs = [[5,1],[4,5],[11,9],[9,4]]`  
**Output:**  
`[[11,9],[9,4],[4,5],[5,1]]`  

**Explanation:**  
This arrangement is valid as:
- end₀ = 9 matches start₁ = 9
- end₁ = 4 matches start₂ = 4
- end₂ = 5 matches start₃ = 5  

#### Example 2:  
**Input:**  
`pairs = [[1,3],[3,2],[2,1]]`  
**Output:**  
`[[1,3],[3,2],[2,1]]`  

**Explanation:**  
This arrangement is valid as:
- end₀ = 3 matches start₁ = 3
- end₁ = 2 matches start₂ = 2  

Alternative arrangements, like `[[2,1],[1,3],[3,2]]` or `[[3,2],[2,1],[1,3]]`, are also valid.

#### **Example 3**:
**Input:**  
`pairs = [[1,2], [1,3], [2,1]]`  
**Output:**  
`[[1,2], [2,1], [1,3]]`  

### 🔧 **Constraints**:
- $1 <= pairs.length <= 10^5$
- $`pairs[i].length == 2`$
- $0 <= starti, endi <= 10^9$
- $`starti != endi`$
- `No two pairs are exactly the same.`
- `There exists a valid arrangement of pairs.`


## 🎯 **My Approach:**

This problem can be reduced to finding an **Eulerian Path** in a directed graph:
1. **Graph Construction**:  
   - Represent `pairs` as a directed graph where each pair \([startᵢ, endᵢ]\) forms a directed edge from `startᵢ` to `endᵢ`.  
   - Count the in-degree and out-degree of each node.

2. **Eulerian Path Properties**:  
   - A directed graph contains an **Eulerian Path** if:
     - At most one node has `out-degree - in-degree = 1` (start node).
     - At most one node has `in-degree - out-degree = 1` (end node).
     - All other nodes must have `in-degree = out-degree`.

3. **Hierholzer's Algorithm**:
   - Perform a **Depth-First Search (DFS)** to construct the Eulerian path starting from the node with `out-degree - in-degree = 1`, if it exists.

##### Use Hierholzer’s Algorithm to construct the Eulerian path:
   - Perform a **DFS** to traverse all edges exactly once.
   - Store the edges in reverse order and reverse the result at the end.
     
4. **Output**:
   - Reverse the path obtained from the DFS to produce the correct arrangement.



## 🕒 **Time Complexity:**

- **Time Complexity**:  
  $\(O(E + V)\)$, where $\(E\)$ is the number of pairs, and $\(V\)$ is the number of unique nodes.  
  - Constructing the graph takes $\(O(E)\)$.  
  - Traversing all edges (DFS) takes $\(O(E + V)\)$.

- **Space Complexity**:  
  $\(O(E + V)\)$, for storing the graph and visited edges.


## 📝 **Solution Code**


<details>
  <summary><h2 align='center'>👨‍💻 C Solution Problem</h2></summary>

1. **Common Mistakes in C**:
   - Memory management issues (e.g., forgetting to allocate enough memory or freeing incorrectly).
   - Incorrect handling of graphs, especially with dynamic data structures.
   - Misunderstanding of the Eulerian Path logic, particularly in Hierholzer's algorithm.

2. **Why Eulerian Path Might Be Hard in C**:
   - The need for dynamic graph representations.
   - Recursion in DFS can lead to stack overflow for large inputs unless handled iteratively.

### Why C Is Challenging Here:
1. **Graph Representation**: 
   Handling adjacency lists with dynamic memory is cumbersome. 
2. **Efficiency**: 
   Python, Java, and Rust handle dictionaries or hash maps efficiently, which simplifies identifying in-degrees and out-degrees.

### Suggested Next Steps:  

1. **Request Pull Requests (PRs)**:
   - Encourage contributors to submit solutions for C with a detailed explanation.
   - You could create an **Issue** in your repository clearly explaining the problem. Here's a template:  


#### **Issue Template for C Implementation**:

**Title:**  
"Help Needed: Valid Arrangement of Pairs in C"  

**Description:**  
Hi Contributors! 🚀  
I'm stuck implementing the **Valid Arrangement of Pairs** problem in **C language**.  

**Problem:**  
The Eulerian Path logic works in other languages, but my C implementation has failed 13 test cases.  
- Suspected areas: Memory allocation, graph traversal logic, edge case handling.  


### What I Have Tried:
- Built adjacency lists using arrays.
- Used DFS for edge traversal and Eulerian path construction.  
 


## How You Can Help:
1. Solve the problem using C.
2. Submit a **PR** with the solution and a short explanation.
3. Optimize for clarity and large inputs.

Here's the problem link: [LeetCode Problem 2097](https://leetcode.com/problems/valid-arrangement-of-pairs/?envType=daily-question&envId=2024-11-30)  

## Code (C)

```c
typedef struct Node {
    int value;
    struct Node* next;
} Node;
void addEdge(Node** adjList, int from, int to) {
    Node* newNode = (Node*)malloc(sizeof(Node));
    newNode->value = to;
    newNode->next = adjList[from];
    adjList[from] = newNode;
}
void dfs(int node, Node** adjList, int** result, int* index) {
    while (adjList[node]) {
        Node* curr = adjList[node];
        int next = curr->value;
        adjList[node] = curr->next;
        dfs(next, adjList, result, index);
        free(curr);
    }
    (*result)[(*index)--] = node;
}
int** validArrangement(int** pairs, int pairsSize, int* pairsColSize, int* returnSize, int** returnColumnSizes) {
    int minNode = INT_MAX, maxNode = INT_MIN;
    for (int i = 0; i < pairsSize; i++) {
        if (pairs[i][0] < minNode) minNode = pairs[i][0];
        if (pairs[i][1] < minNode) minNode = pairs[i][1];
        if (pairs[i][0] > maxNode) maxNode = pairs[i][0];
        if (pairs[i][1] > maxNode) maxNode = pairs[i][1];
    }
    int nodeRange = maxNode - minNode + 1;
    Node** adjList = (Node**)calloc(nodeRange, sizeof(Node*));
    int* inDegree = (int*)calloc(nodeRange, sizeof(int));
    int* outDegree = (int*)calloc(nodeRange, sizeof(int));
    for (int i = 0; i < pairsSize; i++) {
        int from = pairs[i][0] - minNode; 
        int to = pairs[i][1] - minNode;
        addEdge(adjList, from, to);
        outDegree[from]++;
        inDegree[to]++;
    }
    int startNode = pairs[0][0] - minNode; 
    for (int i = 0; i < nodeRange; i++) {
        if (outDegree[i] - inDegree[i] == 1) {
            startNode = i;
            break;
        }
    }
    int* result = (int*)malloc((pairsSize + 1) * sizeof(int));
    int index = pairsSize;
    dfs(startNode, adjList, &result, &index);
    *returnSize = pairsSize;
    *returnColumnSizes = (int*)malloc(pairsSize * sizeof(int));
    int** output = (int**)malloc(pairsSize * sizeof(int*));
    for (int i = 0; i < pairsSize; i++) {
        output[i] = (int*)malloc(2 * sizeof(int));
        output[i][0] = result[i] + minNode; 
        output[i][1] = result[i + 1] + minNode;
        (*returnColumnSizes)[i] = 2;
    }
    free(result);
    free(adjList);
    free(inDegree);
    free(outDegree);
    return output;
}
```

</details>

## Code (C++)

```cpp
class Solution {
public:
    unordered_map<int, vector<int>> adj;
    unordered_map<int, int> deg;

    void buildGraph(const vector<vector<int>>& pairs) {
        for (const auto& edge : pairs) {
            int u = edge[0], v = edge[1];
            adj[u].push_back(v);
            deg[u]++;
            deg[v]--;
        }
    }

    vector<int> findEulerianPath(int start) {
        vector<int> result;
        stack<int> stk;
        stk.push(start);

        while (!stk.empty()) {
            int node = stk.top();
            if (adj[node].empty()) {
                result.push_back(node);
                stk.pop();
            } else {
                int next = adj[node].back();
                adj[node].pop_back();
                stk.push(next);
            }
        }
        return result;
    }

    vector<vector<int>> validArrangement(vector<vector<int>>& pairs) {
        int n = pairs.size();
        adj.reserve(n);
        deg.reserve(n);

        buildGraph(pairs);

        int startNode = -1;
        for (const auto& [node, degree] : deg) {
            if (degree == 1) {
                startNode = node;
                break;
            }
        }
        if (startNode == -1) startNode = pairs[0][0];

        vector<int> eulerPath = findEulerianPath(startNode);
        reverse(eulerPath.begin(), eulerPath.end());

        vector<vector<int>> result;
        result.reserve(n);
        for (size_t i = 1; i < eulerPath.size(); ++i) {
            result.push_back({eulerPath[i - 1], eulerPath[i]});
        }

        return result;
    }
};
```

## Code (Java)

```java
class Solution {
    public int[][] validArrangement(int[][] pairs) {
        Map<Integer, Deque<Integer>> adjacencyList = new HashMap<>();
        Map<Integer, Integer> degree = new HashMap<>();

        for (int[] pair : pairs) {
            adjacencyList.computeIfAbsent(pair[0], k -> new ArrayDeque<>()).addLast(pair[1]);
            degree.put(pair[0], degree.getOrDefault(pair[0], 0) + 1);
            degree.put(pair[1], degree.getOrDefault(pair[1], 0) - 1);
        }

        int startNode = pairs[0][0];
        for (int node : degree.keySet()) {
            if (degree.get(node) == 1) {
                startNode = node;
                break;
            }
        }

        List<Integer> path = new ArrayList<>();
        Deque<Integer> stack = new ArrayDeque<>();
        stack.push(startNode);

        while (!stack.isEmpty()) {
            while (!adjacencyList.getOrDefault(stack.peek(), new ArrayDeque<>()).isEmpty()) {
                stack.push(adjacencyList.get(stack.peek()).pollLast());
            }
            path.add(stack.pop());
        }

        int[][] result = new int[pairs.length][2];
        for (int i = path.size() - 1, j = 0; i > 0; i--, j++) {
            result[j] = new int[]{path.get(i), path.get(i - 1)};
        }

        return result;
    }
}
```

## Code (Python)

```python3
from collections import defaultdict, deque
from typing import List

class Solution:
    def validArrangement(self, pairs: List[List[int]]) -> List[List[int]]:
        graph = defaultdict(list)
        inOutDeg = defaultdict(int)

        for start, end in pairs:
            graph[start].append(end)
            inOutDeg[start] += 1  
            inOutDeg[end] -= 1    

        startNode = pairs[0][0] 
        for node in inOutDeg:
            if inOutDeg[node] == 1:
                startNode = node
                break

        path = []
        def dfs(curr):
            while graph[curr]:
                nextNode = graph[curr].pop()
                dfs(nextNode)
                path.append((curr, nextNode))

        dfs(startNode)
        return path[::-1]
```

## Code (Rust)

```rust
use std::collections::{HashMap, VecDeque};

impl Solution {
    pub fn valid_arrangement(pairs: Vec<Vec<i32>>) -> Vec<Vec<i32>> {
        let mut adjacency_list: HashMap<i32, Vec<i32>> = HashMap::with_capacity(pairs.len());
        let mut in_out_degree: HashMap<i32, i32> = HashMap::with_capacity(pairs.len() * 2);

        for pair in &pairs {
            adjacency_list.entry(pair[0])
                .or_insert_with(Vec::new)
                .push(pair[1]);
            *in_out_degree.entry(pair[0]).or_default() += 1;
            *in_out_degree.entry(pair[1]).or_default() -= 1;
        }

        let mut start_node = pairs[0][0];
        for (&node, &degree) in &in_out_degree {
            if degree == 1 {
                start_node = node;
                break;
            }
        }

        let mut path = Vec::with_capacity(pairs.len() + 1);
        let mut node_stack = vec![start_node];

        while !node_stack.is_empty() {
            if let Some(neighbors) = adjacency_list.get_mut(&node_stack[node_stack.len() - 1]) {
                if neighbors.is_empty() {
                    path.push(node_stack.pop().unwrap());
                } else {
                    let next_node = neighbors.pop().unwrap();
                    node_stack.push(next_node);
                }
            } else {
                path.push(node_stack.pop().unwrap());
            }
        }

        let mut arrangement = Vec::with_capacity(path.len() - 1);
        let path_size = path.len();

        for i in (1..path_size).rev() {
            arrangement.push(vec![path[i], path[i-1]]);
        }

        arrangement
    }
}
```


# 🎯 **Contribute or Ask Questions:**
For more discussions, questions, or help with the solution, feel free to reach out on LinkedIn: [**Connect with Me!**](https://www.linkedin.com/in/het-patel-8b110525a/).

## <img src="https://github.com/user-attachments/assets/35f6838c-52f5-4e48-8a98-c5203f8c57e3" style="width:29px; color: #FFD700" alt="Star GIF"> **Enjoying the Solution?**  
If this helped you, please **star this repo** to support the efforts and keep it growing!
